;;; 
;;; Virtual Disk Drive Project	- Nov 11, 2003 (EJR)
;;;
;;; Simple Wait routines - used in generating data delays
;;; This is the code page 1 souce file.  See waitP2.asm for
;;; waits that should be called when in page 2.

#include "vd.h"
#include "headmove.mac"
	
PROG1 CODE
   global Wait6cP1	      ; the following are "call" versions of "Wait"
   global Wait7cP1
   global Wait8cP1
   global Wait9cP1
   global Wait10cP1
   global Wait11cP1
   global Wait12cP1
   global Wait13cP1
   global Wait14cP1
   global Wait15cP1
   global Wait16cP1
   global Wait17cP1
   global Wait18cP1
   global Wait19cP1
   global Wait20cP1
   global Wait21cP1
   global Wait22cP1
   global Wait23cP1
   global Wait24cP1
   global Wait25cP1

;;;**********************************************************************
;;; NAME:	Wait Calls
;;;
;;; DESCR:	Wait for a time.  Use the spare time to call headcheck().
;;;
;;;		Since a call takes 2, and a return takes 2, the smallest
;;;		wait that can be done with a call is 4 instruction cycles.
;;;
;;; ARGS:	None
;;;
;;; RETURNS:	Nada
;;;
;;; NOTES:	- this used to be a real pretty cascade of waits that
;;;		  looked like:
;;;
;;;			...
;;;			Wait17c:	nop
;;;			Wait16c:	nop
;;;			Wait15c:	nop
;;;			Wait14c:	nop
;;;			...
;;;		   But it was changed to do as many HeadChecks as possible
;;;		   while waiting...why not?
;;;		- HeadChecks are done every 4 instruction cycles for
;;;		  waits 6 or longer
;;;**********************************************************************

Wait25cP1:	nop
Wait24cP1:	nop	
Wait23cP1:	nop	
Wait22cP1:	HeadCheckPage1
		goto	Wait18cP1

Wait21cP1:	nop
Wait20cP1:	nop	
Wait19cP1:	nop	
Wait18cP1:	HeadCheckPage1
		goto	Wait14cP1

Wait17cP1:	nop
Wait16cP1:	nop
Wait15cP1:	nop
Wait14cP1:	HeadCheckPage1
		goto	Wait10cP1
	
Wait13cP1:	nop
Wait12cP1:	nop
Wait11cP1:	nop
Wait10cP1:	HeadCheckPage1
		goto	Wait6cP1
	
Wait9cP1:	nop		; fall through to Wait8
Wait8cP1:	nop		; fall through to Wait7
Wait7cP1:	nop		; fall through to Wait6
Wait6cP1:	HeadCheckPage1
		return

;;; ---------------------------------------------------------------------------
;;; ---------------------------------------------------------------------------
	
	END
